/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DrakeFamiliarEffect
extends OneShotEffect {
    DrakeFamiliarEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice it unless you return an enchantment to its owner's hand.";
    }

    private DrakeFamiliarEffect(DrakeFamiliarEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_PERMANENT_ENCHANTMENT);
        target.withNotTarget(true);
        if (target.canChoose(controller.getId(), source, game) && controller.chooseUse(this.outcome, "Return an enchantment to its owner's hand?", source, game)) {
            controller.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
            permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                return controller.moveCards((Card)permanent, Zone.HAND, source, game);
            }
        }
        return (permanent = source.getSourcePermanentIfItStillExists(game)) != null && permanent.sacrifice(source, game);
    }

    public DrakeFamiliarEffect copy() {
        return new DrakeFamiliarEffect(this);
    }
}

