/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DralnusCrusadeEffect
extends ContinuousEffectImpl {
    DralnusCrusadeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "All Goblins are black and are Zombies in addition to their other creature types";
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE_GOBLINS, source.getControllerId(), source, game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.ZOMBIE});
                    break;
                }
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setColor(ObjectColor.BLACK);
                }
            }
        }
        return true;
    }

    private DralnusCrusadeEffect(DralnusCrusadeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DralnusCrusadeEffect copy() {
        return new DralnusCrusadeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.ColorChangingEffects_5;
    }
}

