/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DramatistsPuppetEffect
extends OneShotEffect {
    DramatistsPuppetEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each kind of counter on target permanent, put another counter of that kind on it or remove one from it";
    }

    private DramatistsPuppetEffect(DramatistsPuppetEffect effect) {
        super((OneShotEffect)effect);
    }

    public DramatistsPuppetEffect copy() {
        return new DramatistsPuppetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || permanent == null) {
            return false;
        }
        List counterNames = permanent.getCounters(game).values().stream().map(Counter::getName).collect(Collectors.toList());
        for (String counterName : counterNames) {
            Counter newCounter = CounterType.findByName((String)counterName).createInstance();
            if (controller.chooseUse(Outcome.BoostCreature, "Add or remove a " + counterName + " counter?", null, "Add", "Remove", source, game)) {
                permanent.addCounters(newCounter, source.getControllerId(), source, game);
                continue;
            }
            permanent.removeCounters(newCounter, source, game);
        }
        return true;
    }
}

