/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DreadDefilerEffect
extends OneShotEffect {
    DreadDefilerEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target opponent loses life equal to the exiled card's power";
    }

    private DreadDefilerEffect(DreadDefilerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreadDefilerEffect copy() {
        return new DreadDefilerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent;
        int amount = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof ExileFromGraveCost)) continue;
            Card card = game.getCard(cost.getTargets().getFirstTarget());
            if (card == null) break;
            amount = card.getPower().getValue();
            break;
        }
        if (amount > 0 && (targetOpponent = game.getPlayer(source.getFirstTarget())) != null) {
            targetOpponent.loseLife(amount, game, source, false);
            return true;
        }
        return false;
    }
}

