/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.util.CardUtil;

class DreadSummonsEffect
extends OneShotEffect {
    private static final Token token = new ZombieToken();

    DreadSummonsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "each player mills X cards. For each creature card put into a graveyard this way, you create a tapped 2/2 black Zombie creature token";
    }

    private DreadSummonsEffect(DreadSummonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreadSummonsEffect copy() {
        return new DreadSummonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int creatureCount = 0;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            creatureCount = (int)((long)creatureCount + player.millCards(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), source, game).getCards(game).stream().filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()) == Zone.GRAVEYARD).filter(card1 -> card1.isCreature(game)).count());
        }
        if (creatureCount > 0) {
            game.processAction();
            token.putOntoBattlefield(creatureCount, game, source, source.getControllerId(), true, false);
        }
        return true;
    }
}

