/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class DreamCacheEffect
extends OneShotEffect {
    DreamCacheEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw three cards, then put two cards from your hand both on top of your library or both on the bottom of your library.";
    }

    private DreamCacheEffect(DreamCacheEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamCacheEffect copy() {
        return new DreamCacheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(3, source, game);
            boolean putOnTop = controller.chooseUse(Outcome.Neutral, "Put cards on top?", source, game);
            TargetCardInHand target = new TargetCardInHand(2, 2, new FilterCard());
            controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            CardsImpl cardsToLibrary = new CardsImpl((Collection)target.getTargets());
            if (!cardsToLibrary.isEmpty()) {
                if (putOnTop) {
                    controller.putCardsOnTopOfLibrary((Cards)cardsToLibrary, game, source, false);
                } else {
                    controller.putCardsOnBottomOfLibrary((Cards)cardsToLibrary, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

