/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class DredgeTheMireEffect
extends OneShotEffect {
    DredgeTheMireEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent chooses a creature card in their graveyard. Put those cards onto the battlefield under your control.";
    }

    private DredgeTheMireEffect(DredgeTheMireEffect effect) {
        super((OneShotEffect)effect);
    }

    public DredgeTheMireEffect copy() {
        return new DredgeTheMireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(opponentId);
            if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) == 0) continue;
            TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
            target.withNotTarget(true);
            if (!player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) continue;
            cards.add((Object)target.getFirstTarget());
        }
        return controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }
}

