/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;

class DredgingClawTriggeredAbility
extends TriggeredAbilityImpl {
    DredgingClawTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AttachEffect(Outcome.BoostCreature), true);
    }

    private DredgingClawTriggeredAbility(DredgingClawTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DredgingClawTriggeredAbility copy() {
        return new DredgingClawTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        EntersTheBattlefieldEvent etbEvent = (EntersTheBattlefieldEvent)event;
        return etbEvent.getTarget().isCreature(game) && etbEvent.getFromZone() == Zone.GRAVEYARD && this.isControlledBy(etbEvent.getTarget().getOwnerId());
    }

    public String getRule() {
        return "Whenever a creature enters from your graveyard, you may attach {this} to it.";
    }
}

