/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.FightTargetsEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.TargetSpell;
import mage.target.common.TargetControlledCreaturePermanent;

public final class DromokasCommand
extends CardImpl {
    private static final FilterEnchantmentPermanent filterEnchantment = new FilterEnchantmentPermanent("an enchantment");
    private static final FilterCreaturePermanent filterCreature = new FilterCreaturePermanent("creature to put a +1/+1 counter on it");

    public DromokasCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{G}{W}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().getEffects().add((Object)new PreventDamageByTargetEffect(Duration.EndOfTurn, false).withTextOptions(false, true));
        this.getSpellAbility().getTargets().add((Target)new TargetSpell((FilterSpell)new FilterInstantOrSorcerySpell()));
        SacrificeEffect effect = new SacrificeEffect((FilterPermanent)filterEnchantment, 1, "target player");
        effect.setText("Target player sacrifices an enchantment");
        Mode mode = new Mode((Effect)effect);
        mode.addTarget((Target)new TargetPlayer());
        this.getSpellAbility().getModes().addMode(mode);
        effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance());
        effect.setText("Put a +1/+1 counter on target creature");
        mode = new Mode((Effect)effect);
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filterCreature));
        this.getSpellAbility().getModes().addMode(mode);
        effect = new FightTargetsEffect();
        effect.setText("Target creature you control fights target creature you don't control");
        mode = new Mode((Effect)effect);
        mode.addTarget((Target)new TargetControlledCreaturePermanent());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        this.getSpellAbility().getModes().addMode(mode);
    }

    private DromokasCommand(DromokasCommand card) {
        super((CardImpl)card);
    }

    public DromokasCommand copy() {
        return new DromokasCommand(this);
    }
}

