/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ColoredManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ColoredManaSymbol;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.permanent.token.SkeletonRegenerateToken;
import mage.game.permanent.token.Token;
import mage.target.common.TargetCardInYourGraveyard;

public final class DrudgeSpell
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("Skeleton tokens");

    public DrudgeSpell(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{B}{B}");
        CreateTokenEffect effect = new CreateTokenEffect((Token)new SkeletonRegenerateToken());
        effect.setText("create a 1/1 black Skeleton creature token. It has \"{B}: Regenerate this creature.\"");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)effect, (Cost)new ColoredManaCost(ColoredManaSymbol.B));
        ability.addCost((Cost)new ExileFromGraveCost(new TargetCardInYourGraveyard(2, 2, (FilterCard)StaticFilters.FILTER_CARD_CREATURES_YOUR_GRAVEYARD)));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LeavesBattlefieldTriggeredAbility((Effect)new DestroyAllEffect(filter, true), false));
    }

    private DrudgeSpell(DrudgeSpell card) {
        super((CardImpl)card);
    }

    public DrudgeSpell copy() {
        return new DrudgeSpell(this);
    }

    static {
        filter.add((Predicate)SubType.SKELETON.getPredicate());
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

