/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class DruidOfTheEmeraldGroveEffect
extends RollDieWithResultTableEffect {
    DruidOfTheEmeraldGroveEffect() {
        super(20, "search your library for up to two basic lands cards and reveal them, then roll a d20");
        this.addTableEntry(1, 9, new Effect[]{new InfoEffect("put those cards into your hand, then shuffle")});
        this.addTableEntry(10, 19, new Effect[]{new InfoEffect("put one of those cards onto the battlefield tapped and the other into your hand, then shuffle")});
        this.addTableEntry(20, 20, new Effect[]{new InfoEffect("put those cards onto the battlefield tapped, then shuffle")});
    }

    private DruidOfTheEmeraldGroveEffect(DruidOfTheEmeraldGroveEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public DruidOfTheEmeraldGroveEffect copy() {
        return new DruidOfTheEmeraldGroveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary targetCardInLibrary = new TargetCardInLibrary(0, 2, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LANDS);
        player.searchLibrary(targetCardInLibrary, source, game);
        CardsImpl cards = new CardsImpl();
        targetCardInLibrary.getTargets().stream().map(uuid -> player.getLibrary().getCard(uuid, game)).filter(Objects::nonNull).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.revealCards(source, (Cards)cards, game);
        int amount = player.rollDice(this.outcome, source, game, 20);
        if (amount >= 1) {
            if (amount <= 9) {
                player.moveCards((Cards)cards, Zone.HAND, source, game);
            } else if (amount <= 19) {
                Card card;
                switch (cards.size()) {
                    case 0: {
                        card = null;
                        break;
                    }
                    case 1: {
                        card = cards.getRandom(game);
                        break;
                    }
                    default: {
                        TargetCardInLibrary target = new TargetCardInLibrary();
                        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                        card = cards.get(target.getFirstTarget(), game);
                    }
                }
                if (card != null) {
                    player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
                    cards.remove(card);
                }
                player.moveCards((Cards)cards, Zone.HAND, source, game);
            } else {
                player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

