/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class DrumHunterTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power 5 or greater");

    public DrumHunterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
    }

    private DrumHunterTriggeredAbility(DrumHunterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public DrumHunterTriggeredAbility copy() {
        return new DrumHunterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.END_TURN_STEP_PRE && event.getPlayerId().equals(this.controllerId);
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getBattlefield().countAll((FilterPermanent)filter, this.controllerId, game) > 0;
    }

    public String getRule() {
        return "At the beginning of your end step, if you control a creature with power 5 or greater, you may draw a card.";
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 4));
    }
}

