/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class DualNatureCreateTokenEffect
extends OneShotEffect {
    DualNatureCreateTokenEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "its controller creates a token that's a copy of that creature";
    }

    private DualNatureCreateTokenEffect(DualNatureCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public DualNatureCreateTokenEffect copy() {
        return new DualNatureCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(permanent.getControllerId());
            effect.setTargetPointer(this.getTargetPointer().copy());
            effect.apply(game, source);
            Object object = game.getState().getValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game));
            HashSet<UUID> tokensCreated = object != null ? (HashSet<UUID>)object : new HashSet<UUID>();
            for (Permanent perm : effect.getAddedPermanents()) {
                if (perm == null) continue;
                tokensCreated.add(perm.getId());
            }
            game.getState().setValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game), tokensCreated);
        }
        return true;
    }
}

