/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.d.DubiousChallengeMoveToBattlefieldEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DubiousChallengeEffect
extends OneShotEffect {
    DubiousChallengeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top ten cards of your library, exile up to two creature cards from among them, then shuffle. Target opponent may choose one of the exiled cards and put it onto the battlefield under their control. Put the rest onto the battlefield under your control.";
    }

    private DubiousChallengeEffect(DubiousChallengeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DubiousChallengeEffect copy() {
        return new DubiousChallengeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl topCards = new CardsImpl();
            topCards.addAllCards((Collection)controller.getLibrary().getTopCards(game, 10));
            controller.lookAtCards(sourceObject.getIdName(), (Cards)topCards, game);
            TargetCard targetCreatures = new TargetCard(0, 2, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            controller.choose(this.outcome, (Cards)topCards, targetCreatures, source, game);
            CardsImpl exiledCards = new CardsImpl((Collection)targetCreatures.getTargets());
            if (!exiledCards.isEmpty()) {
                controller.moveCards((Cards)exiledCards, Zone.EXILED, source, game);
                controller.shuffleLibrary(source, game);
                Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                if (opponent != null) {
                    Card card;
                    TargetCard targetOpponentCreature = new TargetCard(0, 1, Zone.EXILED, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
                    DubiousChallengeMoveToBattlefieldEffect opponentEffect = (DubiousChallengeMoveToBattlefieldEffect)((Object)source.getEffects().get(1));
                    DubiousChallengeMoveToBattlefieldEffect controllerEffect = (DubiousChallengeMoveToBattlefieldEffect)((Object)source.getEffects().get(2));
                    if (opponent.choose(this.outcome, (Cards)exiledCards, targetOpponentCreature, source, game) && (card = game.getCard(targetOpponentCreature.getFirstTarget())) != null) {
                        opponentEffect.setPlayerAndCards(opponent, (Cards)new CardsImpl(card));
                        exiledCards.remove(card);
                    }
                    if (!exiledCards.isEmpty()) {
                        controllerEffect.setPlayerAndCards(controller, (Cards)exiledCards);
                    }
                }
            } else {
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

