/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;

class DungeonDelverEffect
extends ReplacementEffectImpl {
    DungeonDelverEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "room abilities of dungeons you own trigger an additional time";
    }

    private DungeonDelverEffect(DungeonDelverEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DungeonDelverEffect copy() {
        return new DungeonDelverEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        GameEvent gameEvent = ((NumberOfTriggersEvent)event).getSourceEvent();
        return gameEvent != null && gameEvent.getType() == GameEvent.EventType.ROOM_ENTERED && source.isControlledBy(gameEvent.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

