/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllControlledTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.util.CardUtil;

class DwarvenCatapultEffect
extends OneShotEffect {
    DwarvenCatapultEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage divided evenly, rounded down, among all creatures target opponent controls.";
    }

    private DwarvenCatapultEffect(DwarvenCatapultEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int howMany = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getFirstTarget(), game).size();
        if (howMany > 0) {
            int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) / howMany;
            return new DamageAllControlledTargetEffect(amount, (FilterPermanent)new FilterCreaturePermanent()).apply(game, source);
        }
        return false;
    }

    public DwarvenCatapultEffect copy() {
        return new DwarvenCatapultEffect(this);
    }
}

