/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DwarvenScorcherEffect
extends OneShotEffect {
    DwarvenScorcherEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 1 damage to target creature unless that creature's controller has {this} deal 2 damage to them";
    }

    private DwarvenScorcherEffect(DwarvenScorcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public DwarvenScorcherEffect copy() {
        return new DwarvenScorcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null && player.chooseUse(this.outcome, "Have this spell deal 2 damage to you?", source, game)) {
            return player.damage(2, source.getSourceId(), source, game) > 0;
        }
        return permanent.damage(1, source.getSourceId(), source, game) > 0;
    }
}

