/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.CardTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class RevivalExperimentTarget
extends TargetCardInYourGraveyard {
    private static final CardTypeAssignment cardTypeAssigner = new CardTypeAssignment(new CardType[]{CardType.CREATURE, CardType.LAND});

    RevivalExperimentTarget() {
        super(0, 2, StaticFilters.FILTER_CARD_CREATURE_OR_LAND, true);
    }

    private RevivalExperimentTarget(RevivalExperimentTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public RevivalExperimentTarget copy() {
        return new RevivalExperimentTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        if (!super.canTarget(playerId, id, ability, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return cardTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        possibleTargets.removeIf(uuid -> !this.canTarget(sourceControllerId, (UUID)uuid, source, game));
        return possibleTargets;
    }
}

