/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;

class TransmuteArtifactEffect
extends SearchEffect {
    TransmuteArtifactEffect() {
        super(new TargetCardInLibrary((FilterCard)new FilterArtifactCard()), Outcome.PutCardInPlay);
        this.staticText = "Sacrifice an artifact. If you do, search your library for an artifact card and put that card onto the battlefield. Shuffle your library";
    }

    private TransmuteArtifactEffect(TransmuteArtifactEffect effect) {
        super((SearchEffect)effect);
    }

    public TransmuteArtifactEffect copy() {
        return new TransmuteArtifactEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent;
            boolean sacrifice = false;
            TargetSacrifice targetArtifact = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT);
            if (controller.choose(Outcome.Sacrifice, (Target)targetArtifact, source, game) && (permanent = game.getPermanent(targetArtifact.getFirstTarget())) != null) {
                sacrifice = permanent.sacrifice(source, game);
            }
            if (sacrifice && controller.searchLibrary(this.target, source, game)) {
                if (!this.target.getTargets().isEmpty()) {
                    for (UUID cardId : this.target.getTargets()) {
                        Card card = controller.getLibrary().getCard(cardId, game);
                        if (card == null) continue;
                        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                        controller.shuffleLibrary(source, game);
                        return true;
                    }
                }
                controller.shuffleLibrary(source, game);
            }
        }
        return false;
    }
}

