/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeXTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class AwakenTheBloodAvatarCostReductionEffect
extends CostModificationEffectImpl {
    AwakenTheBloodAvatarCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
    }

    private AwakenTheBloodAvatarCostReductionEffect(AwakenTheBloodAvatarCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof SacrificeXTargetCost)) continue;
            if (game.inCheckPlayableState()) {
                int reduction = ((SacrificeXTargetCost)cost).getMaxValue((Ability)spellAbility, game);
                CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
                break;
            }
            int reduction = ((SacrificeXTargetCost)cost).getAmount();
            CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
            break;
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }

    public AwakenTheBloodAvatarCostReductionEffect copy() {
        return new AwakenTheBloodAvatarCostReductionEffect(this);
    }
}

