/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CantAttackItsOwnerEffect
extends RestrictionEffect {
    CantAttackItsOwnerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "This creature can't attack its owner";
    }

    private CantAttackItsOwnerEffect(CantAttackItsOwnerEffect effect) {
        super((RestrictionEffect)effect);
    }

    public CantAttackItsOwnerEffect copy() {
        return new CantAttackItsOwnerEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null || attacker == null) {
            return true;
        }
        return !defenderId.equals(attacker.getOwnerId());
    }
}

