/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EarnestFellowshipEffect
extends ContinuousEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public EarnestFellowshipEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each creature has protection from its colors";
    }

    private EarnestFellowshipEffect(EarnestFellowshipEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EarnestFellowshipEffect copy() {
        return new EarnestFellowshipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            if (!permanent.getColor(game).hasColor()) continue;
            ArrayList<ColorPredicate> colorPredicates = new ArrayList<ColorPredicate>();
            for (ObjectColor color : permanent.getColor(game).getColors()) {
                colorPredicates.add(new ColorPredicate(color));
            }
            FilterCard filterColors = new FilterCard("its colors");
            filterColors.add(Predicates.or(colorPredicates));
            ProtectionAbility ability = new ProtectionAbility((Filter)filterColors);
            permanent.addAbility((Ability)ability, source.getSourceId(), game);
        }
        return true;
    }
}

