/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EbonPraetorEffect
extends OneShotEffect {
    EbonPraetorEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If the sacrificed creature was a Thrull, put a +1/+0 counter on {this}";
    }

    private EbonPraetorEffect(EbonPraetorEffect effect) {
        super((OneShotEffect)effect);
    }

    public EbonPraetorEffect copy() {
        return new EbonPraetorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            Permanent sacrificedCreature = (Permanent)((SacrificeTargetCost)cost).getPermanents().get(0);
            Permanent sourceCreature = game.getPermanent(source.getSourceId());
            if (!sacrificedCreature.hasSubtype(SubType.THRULL, game) || sourceCreature == null) continue;
            sourceCreature.addCounters(CounterType.P1P0.createInstance(), source.getControllerId(), source, game);
            return true;
        }
        return true;
    }
}

