/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.e.EbondeathDracolichWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.watchers.Watcher;

class EbondeathDracolichEffect
extends AsThoughEffectImpl {
    EbondeathDracolichEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard if a creature not named Ebondeath, Dracolich died this turn";
    }

    private EbondeathDracolichEffect(EbondeathDracolichEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public EbondeathDracolichEffect copy() {
        return new EbondeathDracolichEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId)) {
            Card card = game.getCard(source.getSourceId());
            Watcher watcher = game.getState().getWatcher(EbondeathDracolichWatcher.class);
            if (card != null && watcher != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD) {
                return watcher.conditionMet();
            }
        }
        return false;
    }
}

