/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class EchoingRuinEffect
extends OneShotEffect {
    EchoingRuinEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact and all other artifacts with the same name as that artifact";
    }

    private EchoingRuinEffect(EchoingRuinEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingRuinEffect copy() {
        return new EchoingRuinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null) {
            permanent.destroy(source, game, false);
            if (!CardUtil.haveEmptyName((MageObject)permanent)) {
                for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
                    if (perm.getId().equals(permanent.getId()) || !CardUtil.haveSameNames((MageObject)perm, (MageObject)permanent) || !perm.isArtifact(game)) continue;
                    perm.destroy(source, game, false);
                }
            }
            return true;
        }
        return false;
    }
}

