/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class EcologicalAppreciationEffect
extends OneShotEffect {
    EcologicalAppreciationEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library and graveyard for up to four creature cards with different names that each have mana value X or less and reveal them. An opponent chooses two of those cards. Shuffle the chosen cards into your library and put the rest onto the battlefield";
    }

    private EcologicalAppreciationEffect(EcologicalAppreciationEffect effect) {
        super((OneShotEffect)effect);
    }

    public EcologicalAppreciationEffect copy() {
        return new EcologicalAppreciationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterCreatureCard filter = new FilterCreatureCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        TargetCardWithDifferentNameInLibrary targetCardsInLibrary = new TargetCardWithDifferentNameInLibrary(0, 4, (FilterCard)filter);
        targetCardsInLibrary.withNotTarget(true);
        targetCardsInLibrary.withChooseHint("Step 1 of 2: Search library");
        player.searchLibrary((TargetCardInLibrary)targetCardsInLibrary, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCardsInLibrary.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        int remainingCards = 4 - cards.size();
        if (remainingCards > 0) {
            TargetCardInYourGraveyard targetCardsInGY = new TargetCardInYourGraveyard(0, remainingCards, (FilterCard)filter, (Cards)cards){
                final /* synthetic */ Cards val$cards;
                {
                    this.val$cards = cards;
                    super(x0, x1, x2);
                }

                public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
                    if (!super.canTarget(playerId, id, source, game)) {
                        return false;
                    }
                    Card card = game.getCard(id);
                    Set disallowedCards = this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).collect(Collectors.toSet());
                    HashSet checkList = new HashSet();
                    checkList.addAll(disallowedCards);
                    checkList.addAll(this.val$cards.getCards(game));
                    return EcologicalAppreciationEffect.this.isValidTarget(card, checkList);
                }
            };
            targetCardsInGY.withNotTarget(true);
            targetCardsInGY.withChooseHint("Step 2 of 2: Search graveyard");
            player.choose(Outcome.PutCreatureInPlay, (Cards)player.getGraveyard(), (TargetCard)targetCardsInGY, source, game);
            cards.addAll((Collection)targetCardsInGY.getTargets());
            cards.removeIf(uuid -> {
                Zone zone = game.getState().getZone(uuid);
                return zone != Zone.GRAVEYARD && zone != Zone.LIBRARY;
            });
        }
        TargetOpponent targetOpponent = new TargetOpponent();
        targetOpponent.withNotTarget(true);
        player.choose(this.outcome, (Target)targetOpponent, source, game);
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent != null) {
            TargetCard chosenCards = new TargetCard(2, Zone.ALL, StaticFilters.FILTER_CARD);
            chosenCards.withNotTarget(true);
            opponent.choose(this.outcome, (Cards)cards, chosenCards, source, game);
            CardsImpl toShuffle = new CardsImpl(chosenCards.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).collect(Collectors.toList()));
            player.putCardsOnTopOfLibrary((Cards)toShuffle, game, source, false);
            cards.removeAll((Collection)toShuffle);
            player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    private boolean isValidTarget(Card target, Set<Card> disallowedCards) {
        return target != null && disallowedCards.stream().filter(Objects::nonNull).noneMatch(card -> CardUtil.haveSameNames((MageObject)card, (MageObject)target));
    }
}

