/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class EerieInterferenceEffect
extends PreventionEffectImpl {
    EerieInterferenceEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "prevent all damage that would be dealt to you and creatures you control this turn by creatures";
    }

    private EerieInterferenceEffect(EerieInterferenceEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public EerieInterferenceEffect copy() {
        return new EerieInterferenceEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game)) {
            return false;
        }
        Permanent targetPermanent = game.getPermanent(event.getTargetId());
        boolean isTargetYou = event.getTargetId().equals(source.getControllerId());
        boolean isTargetCreatureYouControl = targetPermanent != null && targetPermanent.isCreature(game) && targetPermanent.isControlledBy(source.getControllerId());
        Permanent permanentSource = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return (isTargetYou || isTargetCreatureYouControl) && permanentSource != null && permanentSource.isCreature(game);
    }
}

