/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class EerieUltimatumTarget
extends TargetCardInYourGraveyard {
    EerieUltimatumTarget() {
        super(0, Integer.MAX_VALUE, (FilterCard)new FilterPermanentCard("permanent cards with different names"), true);
    }

    private EerieUltimatumTarget(EerieUltimatumTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public EerieUltimatumTarget copy() {
        return new EerieUltimatumTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        if (super.canTarget(playerId, id, ability, game)) {
            Set names = this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).map(MageObject::getName).filter(Objects::nonNull).collect(Collectors.toSet());
            Card card = game.getCard(id);
            return card != null && !names.contains(card.getName());
        }
        return false;
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Set names = this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).map(MageObject::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        possibleTargets.removeIf(uuid -> {
            Card card = game.getCard(uuid);
            return card != null && names.contains(card.getName());
        });
        return possibleTargets;
    }
}

