/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.ElderBrainEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ElderBrainTriggeredAbility
extends TriggeredAbilityImpl {
    ElderBrainTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ElderBrainEffect());
        this.setTriggerPhrase("Whenever {this} attacks a player, ");
    }

    private ElderBrainTriggeredAbility(ElderBrainTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ElderBrainTriggeredAbility copy() {
        return new ElderBrainTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(game.getCombat().getDefenderId(this.getSourceId()));
        if (player == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(player.getId()));
        return true;
    }
}

