/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ElderCatharAddCountersTargetEffect
extends OneShotEffect {
    private Counter counter;
    private Counter counter2;

    public ElderCatharAddCountersTargetEffect() {
        super(Outcome.Benefit);
        this.counter = CounterType.P1P1.createInstance(1);
        this.counter2 = CounterType.P1P1.createInstance(2);
        this.staticText = "put a +1/+1 counter on target creature you control. If that creature is a Human, put two +1/+1 counters on it instead";
    }

    private ElderCatharAddCountersTargetEffect(ElderCatharAddCountersTargetEffect effect) {
        super((OneShotEffect)effect);
        this.counter = effect.counter.copy();
        this.counter2 = effect.counter2.copy();
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && this.counter != null) {
            if (permanent.hasSubtype(SubType.HUMAN, game)) {
                permanent.addCounters(this.counter2.copy(), source.getControllerId(), source, game);
            } else {
                permanent.addCounters(this.counter.copy(), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public ElderCatharAddCountersTargetEffect copy() {
        return new ElderCatharAddCountersTargetEffect(this);
    }
}

