/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class EldraziMonumentEffect
extends OneShotEffect {
    EldraziMonumentEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice a creature. If you can't, sacrifice {this}";
    }

    private EldraziMonumentEffect(EldraziMonumentEffect effect) {
        super((OneShotEffect)effect);
    }

    public EldraziMonumentEffect copy() {
        return new EldraziMonumentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        if (target.canChoose(controller.getId(), source, game)) {
            controller.choose(Outcome.Sacrifice, (Target)target, source, game);
            permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                return permanent.sacrifice(source, game);
            }
        }
        if ((permanent = game.getPermanent(source.getSourceId())) != null) {
            return permanent.sacrifice(source, game);
        }
        return false;
    }
}

