/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ElectrodominanceEffect
extends OneShotEffect {
    ElectrodominanceEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may cast a spell with mana value X or less from your hand without paying its mana cost";
    }

    private ElectrodominanceEffect(ElectrodominanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElectrodominanceEffect copy() {
        return new ElectrodominanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0) + 1));
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)controller.getHand(), (FilterCard)filter);
    }
}

