/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ElendaAndAzorEffect
extends OneShotEffect {
    ElendaAndAzorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}{W}{U}{B}. If you do, draw X cards";
    }

    private ElendaAndAzorEffect(ElendaAndAzorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{X}{W}{U}{B}");
            if (controller.chooseUse(Outcome.Damage, "Pay " + cost.getText() + "? If you do, draw X cards.", source, game)) {
                int costX = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to draw)", game, source, true);
                cost.add((Object)new GenericManaCost(costX));
                if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    controller.resetStoredBookmark(game);
                    controller.drawCards(costX, source, game);
                    return true;
                }
            }
        }
        return false;
    }

    public ElendaAndAzorEffect copy() {
        return new ElendaAndAzorEffect(this);
    }
}

