/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class EligethCrossroadsAugurReplacementEffect
extends ReplacementEffectImpl {
    EligethCrossroadsAugurReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would scry a number of cards, draw that many cards instead.";
    }

    private EligethCrossroadsAugurReplacementEffect(EligethCrossroadsAugurReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public EligethCrossroadsAugurReplacementEffect copy() {
        return new EligethCrossroadsAugurReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SCRY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(event.getAmount(), source, game);
        return true;
    }
}

