/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EliteArcanistCopyEffect
extends OneShotEffect {
    EliteArcanistCopyEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Copy the exiled card. You may cast the copy without paying its mana cost. X is the mana value of the exiled card";
    }

    private EliteArcanistCopyEffect(EliteArcanistCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public EliteArcanistCopyEffect copy() {
        return new EliteArcanistCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card copiedCard;
        Player controller;
        Card imprintedInstant;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            sourcePermanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (sourcePermanent != null && sourcePermanent.getImprinted() != null && !sourcePermanent.getImprinted().isEmpty() && (imprintedInstant = game.getCard((UUID)sourcePermanent.getImprinted().get(0))) != null && game.getState().getZone(imprintedInstant.getId()) == Zone.EXILED && (controller = game.getPlayer(source.getControllerId())) != null && (copiedCard = game.copyCard(imprintedInstant, source, source.getControllerId())) != null && controller.chooseUse(Outcome.PlayForFree, "Cast the copied card without paying mana cost?", source, game)) {
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
            Boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
            return cardWasCast;
        }
        return false;
    }
}

