/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ElixerOfImmortalityEffect
extends OneShotEffect {
    ElixerOfImmortalityEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain 5 life. Shuffle {this} and your graveyard into their owner's library";
    }

    private ElixerOfImmortalityEffect(ElixerOfImmortalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null) {
            player.gainLife(5, game, source);
            if (permanent != null) {
                player.moveCardToLibraryWithInfo((Card)permanent, source, game, Zone.BATTLEFIELD, true, true);
            }
            for (Card card : player.getGraveyard().getCards(game)) {
                player.moveCardToLibraryWithInfo(card, source, game, Zone.GRAVEYARD, true, true);
            }
            player.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public ElixerOfImmortalityEffect copy() {
        return new ElixerOfImmortalityEffect(this);
    }
}

