/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ElixirEffect
extends OneShotEffect {
    ElixirEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle all nonland cards from your graveyard into your library. You gain life equal to the number of cards shuffled into your library this way";
    }

    private ElixirEffect(ElixirEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElixirEffect copy() {
        return new ElixirEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game));
        player.shuffleCardsToLibrary((Cards)cards, game, source);
        cards.retainZone(Zone.LIBRARY, game);
        player.gainLife(cards.size(), game, source);
        return true;
    }
}

