/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ElkinLairPutIntoGraveyardEffect
extends OneShotEffect {
    ElkinLairPutIntoGraveyardEffect() {
        super(Outcome.Neutral);
        this.staticText = "if the player hasn't played the card, they put it into their graveyard";
    }

    private ElkinLairPutIntoGraveyardEffect(ElkinLairPutIntoGraveyardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        Set cardsInExile = game.getExile().getExileZone(source.getSourceId()).getCards(game);
        if (cardsInExile == null) {
            return false;
        }
        player.moveCardsToGraveyardWithInfo(cardsInExile, source, game, Zone.EXILED);
        return true;
    }

    public ElkinLairPutIntoGraveyardEffect copy() {
        return new ElkinLairPutIntoGraveyardEffect(this);
    }
}

