/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.EllieBrickMasterEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DefenderAttackedEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EllieBrickMasterTriggeredAbility
extends TriggeredAbilityImpl {
    EllieBrickMasterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new EllieBrickMasterEffect());
        this.setTriggerPhrase("Whenever a player attacks one of your opponents, ");
        this.withFlavorWord("Distract the Horde");
    }

    private EllieBrickMasterTriggeredAbility(EllieBrickMasterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EllieBrickMasterTriggeredAbility copy() {
        return new EllieBrickMasterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DEFENDER_ATTACKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DefenderAttackedEvent dEvent = (DefenderAttackedEvent)event;
        if (!game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        return true;
    }
}

