/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.FaerieDragonToken;
import mage.players.Player;

class ElminsterExileEffect
extends OneShotEffect {
    ElminsterExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. Create a number of 1/1 blue Faerie Dragon creature tokens with flying equal to that card's mana value";
    }

    private ElminsterExileEffect(ElminsterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElminsterExileEffect copy() {
        return new ElminsterExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (card.getManaValue() > 0) {
            new FaerieDragonToken().putOntoBattlefield(card.getManaValue(), game, source);
        }
        return true;
    }
}

