/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class ElminstersSimulacrumAdjusterEffect
extends OneShotEffect {
    ElminstersSimulacrumAdjusterEffect() {
        super(Outcome.Benefit);
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
        this.staticText = "for each opponent, you create a token that's a copy of up to one target creature that player controls";
    }

    private ElminstersSimulacrumAdjusterEffect(ElminstersSimulacrumAdjusterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElminstersSimulacrumAdjusterEffect copy() {
        return new ElminstersSimulacrumAdjusterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setSavedPermanent(permanent);
            effect.apply(game, source);
        }
        return true;
    }
}

