/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.cards.e.CantAttackItsOwnerEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

class ElrondOfWhiteCouncilEffect
extends OneShotEffect {
    ElrondOfWhiteCouncilEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly votes for fellowship or aid, then those votes are revealed. For each fellowship vote, the voter chooses a creature they control. You gain control of each creature chosen this way, and they gain \"This creature can't attack its owner.\" Then for each aid vote, put a +1/+1 counter on each creature you control.";
    }

    private ElrondOfWhiteCouncilEffect(ElrondOfWhiteCouncilEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElrondOfWhiteCouncilEffect copy() {
        return new ElrondOfWhiteCouncilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Fellowship", "Aid", Outcome.Benefit, true);
        vote.doVotes(source, game);
        HashSet<Permanent> chosenCreatures = new HashSet<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player;
            int countFellowship = (int)vote.getVotes(playerId).stream().filter(b -> b).count();
            if (countFellowship < 1 || (player = game.getPlayer(playerId)) == null) continue;
            for (int i = 0; i < countFellowship; ++i) {
                Permanent chosen;
                TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(1);
                target.withNotTarget(true);
                if (!player.chooseTarget(Outcome.Detriment, (Target)target, source, game) || (chosen = game.getPermanent(target.getFirstTarget())) == null) continue;
                game.informPlayers(player.getLogName() + " has chosen " + chosen.getLogName() + CardUtil.getSourceLogName((Game)game, (Ability)source));
                chosenCreatures.add(chosen);
            }
        }
        FixedTargets blueprintTarget = new FixedTargets(new ArrayList(chosenCreatures), game);
        game.addEffect(new GainControlTargetEffect(Duration.WhileOnBattlefield).setTargetPointer(blueprintTarget.copy()), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)new SimpleStaticAbility((Effect)new CantAttackItsOwnerEffect()), Duration.WhileOnBattlefield).setTargetPointer(blueprintTarget.copy()), source);
        game.processAction();
        int countAid = vote.getVoteCount((Object)false);
        if (countAid > 0) {
            new AddCountersAllEffect(CounterType.P1P1.createInstance(countAid), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).apply(game, source);
        }
        return true;
    }
}

