/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ElugeTheShorelessSeaWatcher
extends Watcher {
    private final Map<UUID, Integer> playerInstantOrSorcerySpells = new HashMap<UUID, Integer>();

    ElugeTheShorelessSeaWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return;
        }
        this.playerInstantOrSorcerySpells.put(event.getPlayerId(), this.getInstantOrSorcerySpellsCastThisTurn(event.getPlayerId()) + 1);
    }

    public void reset() {
        this.playerInstantOrSorcerySpells.clear();
        super.reset();
    }

    public int getInstantOrSorcerySpellsCastThisTurn(UUID playerId) {
        return this.playerInstantOrSorcerySpells.getOrDefault(playerId, 0);
    }
}

