/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ElvishImpersonatorsEffect
extends OneShotEffect {
    ElvishImpersonatorsEffect() {
        super(Outcome.Neutral);
        this.staticText = "roll a six-sided die twice. Its base power becomes the first result and its base toughness becomes the second result";
    }

    private ElvishImpersonatorsEffect(ElvishImpersonatorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElvishImpersonatorsEffect copy() {
        return new ElvishImpersonatorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List results = controller.rollDice(this.outcome, source, game, 6, 2, 0);
        int firstRoll = (Integer)results.get(0);
        int secondRoll = (Integer)results.get(1);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(firstRoll, secondRoll, Duration.Custom), source);
        return true;
    }
}

