/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.e.EmberwildeCaptainEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EmberwildeCaptainTriggeredAbility
extends TriggeredAbilityImpl {
    public EmberwildeCaptainTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new EmberwildeCaptainEffect(), false);
    }

    private EmberwildeCaptainTriggeredAbility(EmberwildeCaptainTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) {
            return false;
        }
        if (!player.getId().equals(game.getMonarchId())) {
            return false;
        }
        for (UUID attacker : game.getCombat().getAttackers()) {
            Permanent creature = game.getPermanent(attacker);
            if (creature == null || !player.hasOpponent(creature.getControllerId(), game) || !player.getId().equals(game.getCombat().getDefendingPlayerId(attacker, game))) continue;
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent attacks you while you're the monarch, {this} deals damage to that player equal to the number of cards in their hand.";
    }

    public EmberwildeCaptainTriggeredAbility copy() {
        return new EmberwildeCaptainTriggeredAbility(this);
    }
}

