/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.condition.common.AddendumCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileSpellEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;

class EmergencyPowersEffect
extends OneShotEffect {
    public static final FilterPermanentCard filter = new FilterPermanentCard("a permanent card with mana value 7 or less");

    EmergencyPowersEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile {this}.<br><i>Addendum</i> &mdash; If you cast this spell during your main phase, you may put a permanent card with mana value 7 or less from your hand onto the battlefield.";
    }

    private EmergencyPowersEffect(EmergencyPowersEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmergencyPowersEffect copy() {
        return new EmergencyPowersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (AddendumCondition.instance.apply(game, source)) {
            new PutCardFromHandOntoBattlefieldEffect((FilterCard)filter).apply(game, source);
        }
        return new ExileSpellEffect().apply(game, source);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 8));
    }
}

