/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class EmergentSequenceWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    EmergentSequenceWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && ((EntersTheBattlefieldEvent)event).getTarget().isLand(game)) {
            this.playerMap.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    static int getAmount(UUID playerId, Game game) {
        EmergentSequenceWatcher watcher = (EmergentSequenceWatcher)game.getState().getWatcher(EmergentSequenceWatcher.class);
        return watcher != null ? watcher.playerMap.getOrDefault(playerId, 0) : 0;
    }
}

