/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.MonocoloredPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class EmergentUltimatumEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("monocolored cards with different names");

    EmergentUltimatumEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to three monocolored cards with different names and exile them. An opponent chooses one of those cards. Shuffle that card into your library. You may cast the other cards without paying their mana costs";
    }

    private EmergentUltimatumEffect(EmergentUltimatumEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmergentUltimatumEffect copy() {
        return new EmergentUltimatumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardWithDifferentNameInLibrary targetCardInLibrary = new TargetCardWithDifferentNameInLibrary(0, 3, filter);
        targetCardInLibrary.withNotTarget(true);
        boolean searched = player.searchLibrary((TargetCardInLibrary)targetCardInLibrary, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCardInLibrary.getTargets());
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        if (cards.isEmpty()) {
            if (searched) {
                player.shuffleLibrary(source, game);
            }
            return false;
        }
        TargetOpponent targetOpponent = new TargetOpponent();
        targetOpponent.withNotTarget(true);
        player.choose(this.outcome, (Target)targetOpponent, source, game);
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            if (searched) {
                player.shuffleLibrary(source, game);
            }
            return false;
        }
        TargetCardInExile targetCardInExile = new TargetCardInExile(StaticFilters.FILTER_CARD);
        targetCardInExile.withNotTarget(true);
        opponent.choose(this.outcome, (Cards)cards, (TargetCard)targetCardInExile, source, game);
        Card toShuffle = game.getCard(targetCardInExile.getFirstTarget());
        if (toShuffle != null) {
            player.putCardsOnBottomOfLibrary(toShuffle, game, source);
            player.shuffleLibrary(source, game);
            cards.remove(toShuffle);
        }
        CardUtil.castMultipleWithAttributeForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }

    static {
        filter.add((Predicate)MonocoloredPredicate.instance);
    }
}

