/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class EmeriaTheSkyRuinTriggeredAbility
extends TriggeredAbilityImpl {
    static final FilterLandPermanent filter = new FilterLandPermanent("Plains");

    public EmeriaTheSkyRuinTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ReturnFromGraveyardToBattlefieldTargetEffect(), true);
        this.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD));
    }

    private EmeriaTheSkyRuinTriggeredAbility(EmeriaTheSkyRuinTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EmeriaTheSkyRuinTriggeredAbility copy() {
        return new EmeriaTheSkyRuinTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getPlayerId().equals(this.controllerId);
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getBattlefield().countAll((FilterPermanent)filter, this.controllerId, game) >= 7;
    }

    public String getRule() {
        return "At the beginning of your upkeep, if you control seven or more Plains, you may return target creature card from your graveyard to the battlefield.";
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

