/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.replacement.ThatSpellGraveyardExileReplacementEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class EmetSelchOfTheThirdSeatEffect
extends OneShotEffect {
    EmetSelchOfTheThirdSeatEffect() {
        super(Outcome.Benefit);
        this.staticText = "cast target instant or sorcery card from your graveyard. If that spell would be put into your graveyard, exile it instead";
    }

    private EmetSelchOfTheThirdSeatEffect(EmetSelchOfTheThirdSeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmetSelchOfTheThirdSeatEffect copy() {
        return new EmetSelchOfTheThirdSeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null || !CardUtil.castSingle((Player)player, (Ability)source, (Game)game, (Card)card)) {
            TriggeredAbility.clearDidThisTurn((Ability)source, (Game)game);
            return false;
        }
        game.addEffect(new ThatSpellGraveyardExileReplacementEffect(true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        return true;
    }
}

